/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import java.awt.Component;
import java.awt.Container;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AbstractButton;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Component;

class Button
extends AbstractButton
implements Accessible {
    public Button(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleButtonListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleButton();
    }

    protected Component getComponent(XAccessible xAccessible) {
        Component component = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
        if (component == null) {
            component = AccessibleObjectFactory.createAccessibleComponent(xAccessible);
            if (component instanceof Accessible) {
                ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
            }
            if (component instanceof Container) {
                AccessibleObjectFactory.populateContainer((Container)component, xAccessible.getAccessibleContext());
            }
        }
        return component;
    }

    protected class AccessibleButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleButton() {
            super(Button.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        public int getAccessibleChildrenCount() {
            try {
                return Button.this.unoAccessibleContext.getAccessibleChildCount();
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        public synchronized Accessible getAccessibleChild(int n) {
            try {
                return (Accessible)((Object)Button.this.getComponent(Button.this.unoAccessibleContext.getAccessibleChild(n)));
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return null;
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = Button.this.getComponent(Button.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }
    }

    protected class AccessibleButtonListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleButtonListener() {
            super(Button.this);
        }

        protected AccessibleContext getContext(Object object) {
            try {
                XAccessible xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object);
                Accessible accessible = (Accessible)((Object)Button.this.getComponent(xAccessible));
                return accessible.getAccessibleContext();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 7: {
                    Component component = Button.this.getComponent(Button.this.unoAccessible);
                    Object[] objectArray = new Object[]{null, null};
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        objectArray[0] = this.getContext(accessibleEventObject.OldValue);
                    }
                    if (AnyConverter.isObject((Object)accessibleEventObject.NewValue)) {
                        objectArray[1] = this.getContext(accessibleEventObject.NewValue);
                    }
                    Button.this.firePropertyChange("AccessibleChild", objectArray[0], objectArray[1]);
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

